/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.common.debuffs.IDebuff;
import dev.toma.gunsrpg.common.debuffs.IDebuffContext;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.debuffs.ProgressingDebuff;
import dev.toma.gunsrpg.common.init.ModRegistries;
import dev.toma.gunsrpg.config.debuff.DebuffConfig;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public class PlayerDebuffs
implements IDebuffs {
    private final Map<IDebuffType<?>, IDebuff> debuffMap = new LinkedHashMap();
    private IPlayerCapEntry.IClientSynchReq clientSynchReq;

    @Override
    public <D extends IDebuff> D getDebuff(IDebuffType<D> type) {
        return (D)this.debuffMap.get(type);
    }

    @Override
    public <D extends IDebuff> void add(IDebuffType<D> type, D instance) {
        this.debuffMap.put(type, instance);
    }

    @Override
    public void trigger(IDebuffType.TriggerFlags flags, IDebuffContext context, @Nullable Object data) {
        PlayerEntity player = context.getPlayer();
        Random random = player == null ? null : player.func_70681_au();
        for (IDebuffType type : ModRegistries.DEBUFFS) {
            if (type.isDisabled() || !flags.is(type.getFlags())) continue;
            this.addDebuff(type, context, random, data);
        }
    }

    @Override
    public void toggle(IDebuffType<?> type) {
        Object debuff = this.getDebuff(type);
        if (debuff != null) {
            this.clearDebuff(type);
        } else {
            this.debuffMap.put(type, (IDebuff)type.createRaw());
        }
        this.sync();
    }

    @Override
    public boolean hasDebuff(IDebuffType<?> type) {
        return this.getDebuff(type) != null;
    }

    @Override
    public void clearDebuff(IDebuffType<?> type) {
        this.debuffMap.remove(type);
    }

    @Override
    public void clearActive() {
        this.debuffMap.clear();
        this.sync();
    }

    @Override
    public void heal(IDebuffType<?> type, int amount) {
        Object debuff = this.getDebuff(type);
        if (debuff != null) {
            debuff.heal(amount, this);
        }
        this.clientSynchReq.makeSyncRequest();
    }

    @Override
    public void tick(PlayerEntity player) {
        Iterator<IDebuff> iterator = this.debuffMap.values().iterator();
        while (iterator.hasNext()) {
            IDebuff debuff = iterator.next();
            debuff.tick(player);
            if (!debuff.shouldRemove()) continue;
            iterator.remove();
        }
    }

    @Override
    public void toNbt(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<IDebuffType<?>, IDebuff> entry : this.debuffMap.entrySet()) {
            ResourceLocation id = entry.getKey().getRegistryName();
            IDebuff debuff = entry.getValue();
            CompoundNBT debuffNBT = debuff.toNbt();
            debuffNBT.func_74778_a("type", id.toString());
            list.add((Object)debuffNBT);
        }
        compound.func_218657_a("debuffs", (INBT)list);
    }

    @Override
    public void fromNbt(CompoundNBT compound) {
        ListNBT nbt = compound.func_150297_b("debuffs", 9) ? compound.func_150295_c("debuffs", 10) : new ListNBT();
        this.debuffMap.clear();
        for (int i = 0; i < nbt.size(); ++i) {
            CompoundNBT debuffNbt = nbt.func_150305_b(i);
            String path = debuffNbt.func_74779_i("type");
            ResourceLocation key = new ResourceLocation(path);
            IDebuffType type = (IDebuffType)ModRegistries.DEBUFFS.getValue(key);
            if (type == null) continue;
            Object debuff = type.createRaw();
            debuff.fromNbt(debuffNbt);
            this.debuffMap.put(type, (IDebuff)debuff);
        }
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.clientSynchReq = request;
    }

    @Override
    public Iterable<IDebuff> getActiveAsIterable() {
        return this.debuffMap.values();
    }

    @Override
    public int getFlag() {
        return 8;
    }

    private void sync() {
        if (this.clientSynchReq != null) {
            this.clientSynchReq.makeSyncRequest();
        }
    }

    private <D extends IDebuff> void addDebuff(IDebuffType<D> type, IDebuffContext context, Random random, @Nullable Object data) {
        D debuff = type.onTrigger(context, random, data);
        if (debuff != null) {
            D existing = this.getDebuff(type);
            if (existing instanceof ProgressingDebuff) {
                DebuffConfig config = GunsRPG.config.debuffs;
                ((ProgressingDebuff)existing).incrementProgression(config.additionalDebuffIncrement);
            } else {
                this.add(type, debuff);
            }
            this.sync();
        }
    }
}

